<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class Qoxag_Date_time extends Widget_Base
{

    public $base;

    public function get_name()
    {
        return 'date-time';
    }

    public function get_title()
    {

        return esc_html__('Date and Time', 'qoxag');
    }

    public function get_icon()
    {
        return 'far fa-calendar-alt';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function register_controls()
    {


        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Date settings', 'qoxag'),
            ]
        );


        $this->add_control(
            'date_icon',
            [
                'label' => esc_html__('Select Icon', 'qoxag'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-date',
                ]
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Date color', 'qoxag'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .qoxag-date span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'date_text_align',
            [
                'label' => esc_html__('Alignment', 'qoxag'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [

                    'left' => [
                        'title' => esc_html__('Left', 'qoxag'),
                        'icon' => 'fas fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'qoxag'),
                        'icon' => 'fas fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'qoxag'),
                        'icon' => 'fas fa-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-date' => 'text-align: {{VALUE}};'
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'date_typography',
                'label' => esc_html__('Date Typography', 'qoxag'),
                'selector' => '{{WRAPPER}} .qoxag-date span',
            ]
        );

        $this->add_responsive_control(
            'date_padding',
            [
                'label' => esc_html__('Date Padding', 'qoxag'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-date span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $date_icon = $settings['date_icon'];

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template() {}
}
